# Contributing to the Sandboxie project

- [Monetary contributions](#monetary-contributions)
- [Non-monetary contributions](#non-monetary-contributions)
- [How to help with Sandboxie issues?](#how-to-help-with-sandboxie-issues)

## Monetary contributions

1. Get a [supporter certificate](https://sandboxie-plus.com/go.php?to=sbie-get-cert) <br>
A supporter certificate is like a license key and enables the use of new supporter exclusive features, like [Privacy Mode](https://sandboxie-plus.com/privacy-mode/) or [Application Compartment](https://sandboxie-plus.com/compartment-mode/) sandboxes. See the [Feature Comparison](https://github.com/sandboxie-plus/sandboxie-docs/blob/main/Content/FeatureComparison.md) for more details and certificate options. <br>

2. Get a [Patreon subscription](https://www.patreon.com/DavidXanatos) <br>
Patreon certificates are valid for as long as the subscription is active and unlock all features. Patreons which ended their subscription are entitled to a residual certificate corresponding to the total amount of their support. See also [how to renew a Patreon supporter certificate](https://github.com/sandboxie-plus/Sandboxie/issues/2144).

3. Donate with [PayPal](https://sandboxie-plus.com/go.php?to=donate)

4. Donate with cryptocurrencies <br>
In order to arrange custom payments with cryptocurrencies, please get in touch by [email](https://xanasoft.com/contact/).

In case of issues with your refund request, please get in touch by [email](https://xanasoft.com/contact/) with the full name and order ID.

## Non-monetary contributions

Contributor certificates do not expire (regardless of how many PCs you own) and are available to all people who open meaningful [pull requests](https://docs.github.com/articles/creating-a-pull-request) or provide continued support to the [Sandboxie-docs](https://github.com/sandboxie-plus/sandboxie-docs) / [Sandboxie](https://github.com/sandboxie-plus/Sandboxie) repositories.

For example:

1. You could add a new Sandboxie Plus translation for the language of your country, see also [Localization notes and tips](https://github.com/sandboxie-plus/Sandboxie/discussions/1123#discussioncomment-1203489).
2. You could help to keep updated our [Sandboxie-docs repository](https://github.com/sandboxie-plus/sandboxie-docs) by providing a number of meaningful changes. More volunteers are needed to keep it constantly updated with the new introduced settings mentioned in the [CHANGELOG.md](./CHANGELOG.md) file.
3. You could provide new code changes that fix a specific Sandboxie functionality or introducing a new one.
4. You could offer your availability to become a [collaborator](https://docs.github.com/en/account-and-profile/setting-up-and-managing-your-personal-account-on-github/managing-personal-account-settings/permission-levels-for-a-personal-account-repository#collaborator-access-for-a-repository-owned-by-a-personal-account) in the [Sandboxie-docs](https://github.com/sandboxie-plus/sandboxie-docs) / [Sandboxie](https://github.com/sandboxie-plus/Sandboxie) repositories (after proving your continued support with open issues and/or sufficient skills to manage pull requests).

If you are willing to become a new contributor or collaborator, please get in touch by [email](https://xanasoft.com/contact/) for further details.

## How to help with Sandboxie issues?

We encourage the developers and community to conduct research, report issues, and suggest improvements on this code base.
However, please do not report security vulnerabilities in public comments. A [SECURITY.md](./SECURITY.md) file is available with instructions on responsibly reporting security vulnerabilities.

You may also want to follow the following topics:

- [The least strict sandboxing rules](https://github.com/sandboxie-plus/Sandboxie/issues/1515#issuecomment-1006408988)
- [How to perform trace logs in Sandboxie Plus](https://github.com/sandboxie-plus/Sandboxie/issues/1208#issuecomment-1200170825)
- [How to save Sandboxie messages as a log file](https://sandboxie-plus.github.io/sandboxie-docs/Content/MessagesFromSandboxie.html#log-messages-to-a-file)
- [How to enable the Debug tab in Sandboxie Plus](https://github.com/sandboxie-plus/Sandboxie/issues/2134#issuecomment-1215466315)
- [Useful tools for Sandboxie](https://github.com/sandboxie-plus/Sandboxie#-useful-tools-for-sandboxie)
- [Procmon traces to track file and registry access](https://github.com/sandboxie-plus/Sandboxie/issues/1679#issuecomment-1065760921)
- [Reporting issues to third-party vendors in case of evident conflicts](https://github.com/sandboxie-plus/Sandboxie/issues/2025#issuecomment-1200110235)
- Check out the new introduced features in the [CHANGELOG.md](./CHANGELOG.md) file <br> (a good way to highlight them is a simple search of the `=` sign in your browser)
- Check out whether the problem has already been reported:
<br> - in the [Issues](https://github.com/sandboxie-plus/Sandboxie/issues) section of this repository (grouped into [labels](https://github.com/sandboxie-plus/Sandboxie/labels) for easier searching)
<br> - in the [Discussions](https://github.com/sandboxie-plus/Sandboxie/discussions) section of this repository
<br> - in the [Issues](https://github.com/sandboxie-plus/sandboxie-docs/issues) section of the Sandboxie-docs repository
<br> - in the cached copy of the old Sandboxie forum: `site:https://sandboxie-website-archive.github.io/www.sandboxie.com/old-forums/`
<br> - in the other [support channels](https://github.com/sandboxie-plus/Sandboxie/discussions/1768)
